<?php

/**
 * Class that operate on table 'purchasebill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class PurchasebillMySqlDAO implements PurchasebillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return PurchasebillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM purchasebill WHERE purchasebillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM purchasebill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM purchasebill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param purchasebill primary key
     */
    public function delete($purchasebillid) {
        $sql = 'DELETE FROM purchasebill WHERE purchasebillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($purchasebillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param PurchasebillMySql purchasebill
     */
    public function insert($purchasebill) {
        $sql = 'INSERT INTO purchasebill (rawmaterialssupplierid, purchasebilldate, rawmaterialssupplierdebtbefore, rawmaterialssupplierdebtafter, storerawmaterialid, purchasebilltotalbeforediscount, purchasebilldiscount, purchasebillpayed, purchasebilltotalafterdiscount, tempdelete) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($purchasebill->rawmaterialssupplierid);
        $sqlQuery->set($purchasebill->purchasebilldate);
        $sqlQuery->set($purchasebill->rawmaterialssupplierdebtbefore);
        $sqlQuery->set($purchasebill->rawmaterialssupplierdebtafter);
        $sqlQuery->setNumber($purchasebill->storerawmaterialid);
        $sqlQuery->set($purchasebill->purchasebilltotalbeforediscount);
        $sqlQuery->set($purchasebill->purchasebilldiscount);
        $sqlQuery->set($purchasebill->purchasebillpayed);
        $sqlQuery->set($purchasebill->purchasebilltotalafterdiscount);
        $sqlQuery->setNumber($purchasebill->tempdelete);

        $id = $this->executeInsert($sqlQuery);
        $purchasebill->purchasebillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param PurchasebillMySql purchasebill
     */
    public function update($purchasebill) {
        $sql = 'UPDATE purchasebill SET rawmaterialssupplierid = ?, purchasebilldate = ?, rawmaterialssupplierdebtbefore = ?, rawmaterialssupplierdebtafter = ?, storerawmaterialid = ?, purchasebilltotalbeforediscount = ?, purchasebilldiscount = ?, purchasebillpayed = ?, purchasebilltotalafterdiscount = ?, tempdelete = ? WHERE purchasebillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($purchasebill->rawmaterialssupplierid);
        $sqlQuery->set($purchasebill->purchasebilldate);
        $sqlQuery->set($purchasebill->rawmaterialssupplierdebtbefore);
        $sqlQuery->set($purchasebill->rawmaterialssupplierdebtafter);
        $sqlQuery->setNumber($purchasebill->storerawmaterialid);
        $sqlQuery->set($purchasebill->purchasebilltotalbeforediscount);
        $sqlQuery->set($purchasebill->purchasebilldiscount);
        $sqlQuery->set($purchasebill->purchasebillpayed);
        $sqlQuery->set($purchasebill->purchasebilltotalafterdiscount);
        $sqlQuery->setNumber($purchasebill->tempdelete);

        $sqlQuery->setNumber($purchasebill->purchasebillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM purchasebill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByRawmaterialssupplierid($value) {
        $sql = 'SELECT * FROM purchasebill WHERE rawmaterialssupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPurchasebilldate($value) {
        $sql = 'SELECT * FROM purchasebill WHERE purchasebilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialssupplierdebtbefore($value) {
        $sql = 'SELECT * FROM purchasebill WHERE rawmaterialssupplierdebtbefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialssupplierdebtafter($value) {
        $sql = 'SELECT * FROM purchasebill WHERE rawmaterialssupplierdebtafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStorerawmaterialid($value) {
        $sql = 'SELECT * FROM purchasebill WHERE storerawmaterialid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPurchasebilltotalbeforediscount($value) {
        $sql = 'SELECT * FROM purchasebill WHERE purchasebilltotalbeforediscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPurchasebilldiscount($value) {
        $sql = 'SELECT * FROM purchasebill WHERE purchasebilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPurchasebillpayed($value) {
        $sql = 'SELECT * FROM purchasebill WHERE purchasebillpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPurchasebilltotalafterdiscount($value) {
        $sql = 'SELECT * FROM purchasebill WHERE purchasebilltotalafterdiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdelete($value) {
        $sql = 'SELECT * FROM purchasebill WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByRawmaterialssupplierid($value) {
        $sql = 'DELETE FROM purchasebill WHERE rawmaterialssupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPurchasebilldate($value) {
        $sql = 'DELETE FROM purchasebill WHERE purchasebilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialssupplierdebtbefore($value) {
        $sql = 'DELETE FROM purchasebill WHERE rawmaterialssupplierdebtbefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialssupplierdebtafter($value) {
        $sql = 'DELETE FROM purchasebill WHERE rawmaterialssupplierdebtafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStorerawmaterialid($value) {
        $sql = 'DELETE FROM purchasebill WHERE storerawmaterialid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPurchasebilltotalbeforediscount($value) {
        $sql = 'DELETE FROM purchasebill WHERE purchasebilltotalbeforediscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPurchasebilldiscount($value) {
        $sql = 'DELETE FROM purchasebill WHERE purchasebilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPurchasebillpayed($value) {
        $sql = 'DELETE FROM purchasebill WHERE purchasebillpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPurchasebilltotalafterdiscount($value) {
        $sql = 'DELETE FROM purchasebill WHERE purchasebilltotalafterdiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdelete($value) {
        $sql = 'DELETE FROM purchasebill WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return PurchasebillMySql
     */
    protected function readRow($row) {
        $purchasebill = new Purchasebill();

        $purchasebill->purchasebillid = isset($row['purchasebillid']) ? $row['purchasebillid'] : '';
        $purchasebill->rawmaterialssupplierid = isset($row['rawmaterialssupplierid']) ? $row['rawmaterialssupplierid'] : '';
        $purchasebill->purchasebilldate = isset($row['purchasebilldate']) ? $row['purchasebilldate'] : '';
        $purchasebill->rawmaterialssupplierdebtbefore = isset($row['rawmaterialssupplierdebtbefore']) ? $row['rawmaterialssupplierdebtbefore'] : '';
        $purchasebill->rawmaterialssupplierdebtafter = isset($row['rawmaterialssupplierdebtafter']) ? $row['rawmaterialssupplierdebtafter'] : '';
        $purchasebill->storerawmaterialid = isset($row['storerawmaterialid']) ? $row['storerawmaterialid'] : '';
        $purchasebill->purchasebilltotalbeforediscount = isset($row['purchasebilltotalbeforediscount']) ? $row['purchasebilltotalbeforediscount'] : '';
        $purchasebill->purchasebilldiscount = isset($row['purchasebilldiscount']) ? $row['purchasebilldiscount'] : '';
        $purchasebill->purchasebillpayed = isset($row['purchasebillpayed']) ? $row['purchasebillpayed'] : '';
        $purchasebill->purchasebilltotalafterdiscount = isset($row['purchasebilltotalafterdiscount']) ? $row['purchasebilltotalafterdiscount'] : '';
        $purchasebill->tempdelete = isset($row['tempdelete']) ? $row['tempdelete'] : '';

        return $purchasebill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return PurchasebillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>